<?php
/**
 * WoWRoster.net WoWRoster
 *
 * LICENSE: Licensed under the Creative Commons
 *          "Attribution-NonCommercial-ShareAlike 2.5" license
 *
 * @copyright  2002-2007 WoWRoster.net
 * @license    http://creativecommons.org/licenses/by-nc-sa/2.5   
 *             Creative Commons "Attribution-NonCommercial-ShareAlike 2.5"
 * @version    SVN: $Id: index.php 1703 2008-11-25 03:09:45Z Nefuh $
 * @link       http://www.wowroster.net
 * @package    QuestHistory
 */

if ( !defined('IN_ROSTER') )
{
    exit('Detected invalid access to this file!');
}
require_once($addon['url'].'inc/functions.inc.php');
if ( (isset($_REQUEST['task'])) && ($_REQUEST['task'] != '') )
{
 	$task = $_REQUEST['task']; 	
}
else 
{
  	$task = 'default';
}

// Declare some variables 
$zones = array();
$message = '';
$content = '<style>.overlib_fg { width:600px; }</style>';

if( !$roster->auth->getAuthorized($addon['config']['questhistory_access']) )
{
	print
	'<span class="title_text">'.$roster->locale->act['login'].'</span><br />'.
	$roster->auth->getLoginForm();
	return; //Kicks out of the AddOn and back to the Roster framework
}
else {
	$content .= '<script type="text/javascript" src="'.$addon['url'].'inc/wz_tooltip.js"></script>';
  	// Get member-id from URL
  	$temp = explode(':', $_REQUEST['a']);
  	$pid = $temp[1];
  	// Get member name from DB Members Table
  	$query = "SELECT * FROM `".$roster->db->table('members')."` 
	         WHERE `member_id` = '".$pid."'";
  	if ($roster->db->query($query))
  	{
	  	$result = $roster->db->query($query);
	  	while ($data = $roster->db->fetch($result))
	  	{
		    $member_name = $data['name'];
		}
		/** Get Questzones from DB for selected member-id, 
		 *  if zone is given by url only show this zone else show all zones
		 */
		if ( (isset($_REQUEST['zone'])) && 
		     (!empty($_REQUEST['zone'])) && 
			 ($_REQUEST['zone'] != 'all') )
		{
			$query = "SELECT * FROM `".$roster->db->table('data', 'questhistory')."` 
			         WHERE `pid` = '$pid' AND `zone` = '".$_REQUEST['zone']."' 
					 GROUP BY `zone`";
		}
		else
		{
			$query = "SELECT * FROM `".$roster->db->table('data', 'questhistory')."` 
			         WHERE `pid` = '$pid' 
					 GROUP BY `zone`";
		}
		if ($roster->db->query($query))
		{
		  	$result = $roster->db->query($query);
		  	if ($roster->db->num_rows($result) > 0) 
		  	{
			    while ($data = $roster->db->fetch($result))
			    {
				  	// Build Zone Array
					$zones[] = $data['zone'];
				}
			}
		}
		// Check if there are zones, when not display no-data found.
		if (!empty($zones))
		{			
		  	// Build display foreach zone
			foreach ($zones as $zone)
			{	
				$message .= '<table border="0" cellpadding="5" cellspacing="0" 
							align="center" width="100%">'."\n";
				$message .= '	<tr>'."\n";
				$message .= '		<th colspan="4" style="text-align:left;"><h3><a href="'.
									makelink('char-questhistory&amp;zone='.trim($zone)).
									'" target="_self">'.
									$zone.'</a></h3></th>'."\n";
				$message .= '	</tr>'."\n";
				$message .= '	<tr>'."\n";
				$message .= '		<th style="border-bottom:solid 1px #C3C3C3;">'.
									$roster->locale->act['starttime'].
									'</th><th style="border-bottom:solid 1px #C3C3C3;">'.
									$roster->locale->act['finishtime'].
									'</th><th style="border-bottom:solid 1px #C3C3C3;">'.
									$roster->locale->act['questtitle'].'</th>'."\n";
				$message .= '	</tr>'."\n";
				$query = "SELECT * FROM `".$roster->db->table('data', 'questhistory')."` 
						  WHERE `pid` = '$pid' AND `zone` = '".$roster->db->escape($zone)."' 
						  ORDER BY `".$addon['config']['questhistory_sorting']."` ".
						  $addon['config']['questhistory_sorting_order'];
				$result = $roster->db->query($query);
				while ($data = $roster->db->fetch($result)) 
				{
					$tooltip = gen_tooltip($data);
				  	$message .= '	<tr>'."\n";
				  	$message .= '		<td style="width:25%">'.
					  					recorrect_date($data['start']).
										'</td>'."\n";
				  	$message .= '		<td style="width:25%">'.
					  					recorrect_date($data['finished']).
										'</td>'."\n";
				  	if (!empty($data['group']))
				  	{
					  	$message .= '		<td style="width:40%; text-align:left;">
									<p onmouseover="Tip(\''.$tooltip.'\', CLICKSTICKY, true, CLICKCLOSE, true, CLOSEBTN, true, WIDTH, 600, FONTCOLOR, \'white\', ABOVE, true, BGCOLOR, \'#000000\', CENTERMOUSE, true, TITLE, \''.$data['title'].'\')" onmouseout="UnTip()">['.$data['qlvl'].']&nbsp;'.$data['title'].'</p></td>'."\n";
					}
					else 
					{
					  	$message .= '		<td style="width:40%; text-align:left;"><p onmouseover="Tip(\''.$tooltip.'\', CLICKSTICKY, true, CLICKCLOSE, true, CLOSEBTN, true, WIDTH, 600, FONTCOLOR, \'white\', ABOVE, true, BGCOLOR, \'#000000\', CENTERMOUSE, true, TITLE, \''.$data['title'].'\')" onmouseout="UnTip()">['.$data['qlvl'].']&nbsp;'.$data['title'].'</p></td>'."\n";					  
					}
				  	$message .= '	</tr>'."\n";
				}
				$message .= '</table>'."\n";
				$message .= '<br />'."\n";
			}
			$message .= '<a href="'.makelink('char-questhistory&amp;zone=all').'" target="_self">'.$roster->locale->act['all_zones'].'</a>';
			// Generate Zone Filter
			if ($addon['config']['display_zone_selector'] == 1)
			{
				$content .= border($addon['config']['zonebox_color'], 'start', $roster->locale->act['zone_select'], '50%')."\n";
				$content .= '<form action="'.makelink('char-questhistory').'" method="POST">'."\n";
				$content .= $roster->locale->act['please_select_zone'].': '."\n";
				$query = "SELECT * FROM `".$roster->db->table('data', 'questhistory')."` 
						 WHERE `pid` = '$pid' GROUP BY `zone`";
			 	$result = $roster->db->query($query);
				$content .= '<select name="zone">'."\n";
				if ( (isset($_REQUEST['zone'])) && (!empty($_REQUEST['zone'])) )
				{
					$content .= '	<option value="all">'.
								$roster->locale->act['all_zones'].
								'</option>'."\n";	
				}
				else 
				{
					$content .= '	<option value="all" SELECTED>'.
								$roster->locale->act['all_zones'].
								'</option>'."\n";				  
				}				  
			    while ($data = $roster->db->fetch($result))
			    {
					if ( (isset($_REQUEST['zone'])) && 
					   (!empty($_REQUEST['zone'])) && 
					   ($_REQUEST['zone'] == $roster->db->escape($data['zone'])) )
					{
						$content .= '	<option value="'.$data['zone'].'" SELECTED>'
								    .$data['zone'].'</option>'."\n";					  
					}
					else
					{
						$content .= '	<option value="'.$data['zone'].'">'
								    .$data['zone'].'</option>'."\n";					  
					}
				}
				$content .= '</select>&nbsp;<input type="submit" value="'.
							$roster->locale->act['btn_select'].'" />'."\n";
				$content .= '</form>'."\n";
				$content .= border('sgreen', 'end').'<br />'."\n";
			}
			// Display output
			$content .= scrollbox(
						$message, 
						$roster->locale->act['window_title'].'&nbsp;'.$member_name, 
						$addon['config']['scrollbox_color'], 
						'50%', 
						$addon['config']['scrollbox_height']);
		}
		else {
		  	// Display no data information
		  	$content .= border(
			  		   $addon['config']['messagebox_color'], 
					   'start', 
					   $roster->locale->act['window_title'].
					   '&nbsp;'.
					   $member_name, 
					   '30%')."\n";
		  	$content .= $roster->locale->act['no_data']."\n";
		  	$content .= border('sgreen', 'end')."\n";
		}
		// Display update instructions if set to yes in addon config
		if ($addon['config']['display_update_instructions'] == 1) 
		{
			$content .= '<br />'."\n";
		  	$content .= border(
			  			$addon['config']['instructionbox_color'], 
						'start', 
						$roster->locale->act['update_instruction_title'], 
						'50%')."\n";
		  	$content .= $roster->locale->act['questhistory_update_instructions']."\n";
		  	$content .= border('syellow', 'end');
		}
	}
}