<?php
/**
 * WoWRoster.net WoWRoster
 *
 * LICENSE: Licensed under the Creative Commons
 *          "Attribution-NonCommercial-ShareAlike 2.5" license
 *
 * @copyright  2002-2007 WoWRoster.net
 * @license    http://creativecommons.org/licenses/by-nc-sa/2.5   Creative Commons "Attribution-NonCommercial-ShareAlike 2.5"
 * @version    SVN: $Id: update_hook.php 1703 2008-11-25 03:08:35Z Nefuh $
 * @link       http://www.wowroster.net
 * @package    Quest History
 * @subpackage Functions
*/

/**
 * Name: recorrect_data
 * Description: Function to convert datetime string
 * Parameters: $old_string | Old formated string (YYYY-MM-DD HH:MM:SS)
 * Returns: $new_string | New formated string (DD.MM.YYYY HH:MM:SS)
 */
function recorrect_date ($old_string)
{
	// Split into $temp[0] = date and $temp[1] = time
	$temp = explode (' ', $old_string);
	// Split Date into Day, Month, Year 
	$temp2 = explode ('-', $temp[0]); 
	$day = $temp2[2];
	$month = $temp2[1];
	$year = $temp2[0];
	$time = $temp[1];
	unset($temp2);
	// Build new formated string an return
	$new_string = $day.'.'.$month.'.'.$year.' '.$time;
	return $new_string;			  
}

function gen_tooltip($data, $mode = 2)
{
	global $roster, $locale;
	if (isset($tooltip)) unset ($tooltip);
	$tooltip = '<table border="0" cellpadding="2" cellspacing="0">';
	if ( ($data['tag'] == 'Gruppe') || ($data['tag'] == 'Group') )
	{
	  	$tooltip .= '<tr><td colspan="3">'.$roster->locale->act['groupquest'].'</td></tr>';
	}
	elseif ($data['tag'] == 'Dungeon') 
	{
	  	$tooltip .= '<tr><td colspan="3">'.$roster->locale->act['dungeonquest'].'</td></tr>';
	}
  	$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	$tooltip .= '<tr><td colspan="3">'.strip_tags(nl2br(str_replace('\\n', '<br />', $data['description']))).'</td></tr>';
  	$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	if (!empty($data['objectives']))
	{
	  	$objectives = explode('{', $data['objectives']);
	  	$tooltip .= '<tr><td colspan="3">'.$roster->locale->act['objectives'].'</td></tr>';
	  	foreach ($objectives as $objective)
	  	{
		    if (isset($tmp)) unset($tmp);
			$tmp = explode('|', $objective);
			if ( (isset($tmp[2])) && (!empty($tmp[2])) )
			{
				$num = $tmp[2];
			}
		    $type = $tmp[0];
		    if ($type == 'item')
		    {
			 	if (isset($tmp2)) unset($tmp2);
				$tmp2 = explode('#', $tmp[1]);
				if ($num > 1)
				{
					$tooltip .= '<tr><td>'.$num.'x</td><td colspan="2"><font style="color:#'.$tmp2[0].'";>'.$tmp2[2].'</font></td></tr>';
				}
				else
				{
					$tooltip .= '<tr><td></td><td colspan="2"><font style="color:#'.$tmp2[0].'";>'.$tmp2[2].'</font></td></tr>';								  
				}
			}
			elseif ($type == 'event')
			{
			 	$tooltip .= '<tr><td colspan="3">'.$tmp[1].'</td></tr>'; 	
			}
			elseif ($type == 'monster')
			{
			  	$tooltip .= '<tr><td colspan="3">'.$tmp[1].'</td></tr>';
			}
		}
		$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	}
	if (!empty($data['choices']))
	{
	  	$choices = explode('{', $data['choices']);
	  	$tooltip .= '<tr><td colspan="3">'.$roster->locale->act['rewards'].'</td></tr>';
	  	foreach ($choices as $choice)
	  	{
		 	if (isset($tmp)) unset($tmp);
			$tmp = explode('|', $choice);
			if (!empty($tmp[2])) $tmp[2] = substr($tmp[2], 0, 6);
			if ($tmp[0] == 1)
			{
			  	if ($tmp[1] > 1)
			  	{
			  		$tooltip .= '<tr><td>'.$tmp[1].'x</td><td colspan="2"><font style="color:#'.$tmp[2].';">'.$tmp[4].'</font> ('.$roster->locale->act['selected_item'].')</td></tr>';
			  	}
		  		else
				{
					$tooltip .= '<tr><td></td><td colspan="2"><font style="color:#'.$tmp[2].';">'.$tmp[4].'</font> ('.$roster->locale->act['selected_item'].')</td></tr>';								    
				}
			}   
			elseif (!empty($tmp[0]))
			{
			  	if ($tmp[1] > 1)
			  	{
				  	$tooltip .= '<tr><td>'.$tmp[1].'x</td><td colspan="2"><font style="color:#'.$tmp[2].';">'.$tmp[4].'</font></td></tr>';
				}
				else
				{
				  	$tooltip .= '<tr><td></td><td><font style="color:#'.$tmp[2].';">'.$tmp[4].'</font></td></tr>';								  
				}				  
			}
		}
		$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	}
	if (!empty($data['rewards']))
	{
	  	$rewards = explode('{', $data['rewards']);
	  	$tooltip .= '<tr><td colspan="3">'.$roster->locale->act['rewards_get'].'</td></tr>';
	  	foreach ($rewards as $reward)
	  	{
		 	if (isset($tmp)) unset($tmp);
			$tmp = explode('|', $reward);
			if (!empty($tmp[1])) $tmp[1] = substr($tmp[1], 0, 6);
			if (!empty($tmp[3])) $tooltip .= '<tr><td>'.$tmp[0].'x</td><td colspan="2"><font style="color:#'.$tmp[1].';">'.$tmp[3].'</font></td></tr>';						
		}
	  	$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	}
	$tooltip .= '<tr><td>'.$roster->locale->act['start_npc'].'</td><td colspan="2">'.$data['startnpcname'].' ('.$data['startnpczone'].')</td></tr>';
	$tooltip .= '<tr><td>'.$roster->locale->act['end_npc'].'</td><td colspan="2">'.$data['endnpcname'].' ('.$data['endnpczone'].')</td></tr>';
	$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	$tooltip .= '<tr><td>&nbsp;</td><th style="text-align:center;">X</th><th style="text-align:center;">Y</th></tr>';		
	$tooltip .= '<tr><td>'.$roster->locale->act['start_coords'].'</td><td style="text-align:center;">'.$data['startposx'].'</td><td style="text-align:center;">'.$data['startposy'].'</td></tr>';		
	$tooltip .= '<tr><td>'.$roster->locale->act['end_coords'].'</td><td style="text-align:center;">'.$data['endposx'].'</td><td style="text-align:center;">'.$data['endposy'].'</td></tr>';	
  	$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	if (!empty($data['xp'])) $tooltip .= '<tr><td>'.$roster->locale->act['xp_get'].'</td><td colpan="2">'.$data['xp'].'&nbsp;'.$roster->locale->act['xp'].'</td></tr><tr><td colspan="3">&nbsp;</td></tr>';
	if (!empty($data['honor'])) $tooltip .= '<tr><td>'.$roster->locale->act['honor'].'</td><td colpan="2">'.$data['honor'].'</td></tr><tr><td colspan="3">&nbsp;</td></tr>';
	if (!empty($data['daily'])) $tooltip .= '<tr><td colspan="3">'.$roster->locale->act['dailyquest'].'</td></tr><tr><td colspan="3">&nbsp;</td></tr><tr><td colspan="3">&nbsp;</td></tr>';
	if (!empty($data['fgain']))
	{
	  	$fgains = explode('{', $data['fgain']);
	  	$tooltip .= '<tr><td colspan="3">'.$roster->locale->act['faction_gain'].'</td></tr>';
	  	foreach ($fgains as $fgain)
	  	{
			if (!empty($fgain))
			{
		  	  	if (isset($tmp)) unset($tmp);
		  	  	$tmp = explode('|', $fgain);
	  	  		if ($tmp[1] > 0)
		  	  	{
				 	$tooltip .= '<tr><td>'.$tmp[0].'</td><td colspan="2">+'.$tmp[1].'&nbsp;'.$roster->locale->act['reputation'].'</td></tr>';   							  
				}
				elseif ($tmp[1] < 0)
				{
				 	$tooltip .= '<tr><td>'.$tmp[0].'</td><td colspan="2">-'.$tmp[1].'&nbsp;'.$roster->locale->act['reputation'].'</td></tr>';   							  							  
				}
			}
		}
	 	$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
		unset($tmp);
	}
	if ( (!empty($data['rmoney'])) && ($data['rmoney'] > 0) )
	{
		$copper = intval(substr($data['rmoney'], -2, 2));
		$silver = intval(substr($data['rmoney'], -4, 2));
		$gold = intval(substr($data['rmoney'], 0,strlen($data['rmoney'])-4));
		$tooltip .= '<tr><td>'.$roster->locale->act['rewardmoney'].'</td><td colspan="2">';
		if (!empty($gold))
		{
		  	$tooltip .= $gold.'&nbsp;<img src="'.$roster->config['img_url'].'coin_gold.gif" border="0" alt="'.$roster->locale->act['gold'].'" />&nbsp;';
		}
		if (!empty($silver))
		{
		  	$tooltip .= $silver.'&nbsp;<img src="'.$roster->config['img_url'].'coin_silver.gif" border="0" alt="'.$roster->locale->act['silver'].'" />&nbsp;';
		}
		if (!empty($copper))
		{
		  	$tooltip .= $copper.'&nbsp;<img src="'.$roster->config['img_url'].'coin_copper.gif" border="0" alt="'.$roster->locale->act['copper'].'" />&nbsp;';
		}
		$tooltip .= '</td></tr>';
		$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	}
	if ( (!empty($data['requiredmoney'])) && ($data['requiredmoney'] > 0) ) 
	{
		$copper = intval(substr($data['requiredmoney'], -2, 2));
		$silver = intval(substr($data['requiredmoney'], -4, 2));
		$gold = intval(substr($data['requiredmoney'], 0,strlen($data['requiredmoney'])-4));
	  	$tooltip .= '<tr><td>'.$roster->locale->act['requiredmoney'].'</td><td colspan="2">';
		if (!empty($gold))
		{
		  	$tooltip .= $gold.'&nbsp;<img src="'.$roster->config['img_url'].'coin_gold.gif" border="0" alt="'.$roster->locale->act['gold'].'" />&nbsp;';
		}
		if (!empty($silver))
		{
		  	$tooltip .= $silver.'&nbsp;<img src="'.$roster->config['img_url'].'coin_silver.gif" border="0" alt="'.$roster->locale->act['silver'].'" />&nbsp;';
		}
		if (!empty($copper))
		{
		  	$tooltip .= $copper.'&nbsp;<img src="'.$roster->config['img_url'].'coin_copper.gif" border="0" alt="'.$roster->locale->act['copper'].'" />&nbsp;';
		}
		$tooltip .= '</td></tr>';
	  	$tooltip .= '<tr><td colspan="3">&nbsp;</td></tr>';
	}
	$tooltip .= '	<tr><td>'.$roster->locale->act['qlvl'].'</td><td colspan="2">'.$data['qlvl'].'</td></tr>';
  	$tooltip .= '	<tr><td colspan="3">&nbsp;</td></tr>';
	$tooltip .= '	<tr><td>'.$roster->locale->act['slvl'].'</td><td colspan="2">'.$data['slvl'].'</td></tr>';
  	$tooltip .= '	<tr><td colspan="3">&nbsp;</td></tr>';
	$tooltip .= '	<tr><td>'.$roster->locale->act['flvl'].'</td><td colspan="2">'.$data['flvl'].'</td></tr>';
	$tooltip .= '</table>';
	$tooltip = str_replace('\'', '`', $tooltip);
	$tooltip = str_replace('"', '&quot;', $tooltip);
	return $tooltip;
#	return makeOverlib($tooltip, '['.$data['qlvl'].']&nbsp;'.$data['title'], null, $mode);  
}