<?php
/**
 * WoWRoster.net WoWRoster
 *
 * LICENSE: Licensed under the Creative Commons
 *          "Attribution-NonCommercial-ShareAlike 2.5" license
 *
 * @copyright  2002-2007 WoWRoster.net
 * @license    http://creativecommons.org/licenses/by-nc-sa/2.5   Creative Commons "Attribution-NonCommercial-ShareAlike 2.5"
 * @version    SVN: $Id: install.def.php 1703 2008-11-09 19:10:03Z Nefuh $
 * @link       http://www.wowroster.net
 * @package    QuestHistory
 * @subpackage Installer
*/

if ( !defined('IN_ROSTER') )
{
    exit('Detected invalid access to this file!');
}

/**
 * Installer QuestHistory Addon
 *
 * @package    QuestHistory
 * @subpackage Installer
 */
class questhistoryInstall
{
	var $active = true;
	var $icon = 'inv_misc_book_05';

	var $version = '1.9.9.1703';	// ALWAYS NOTE BELOW IN upgrade() WHY THE VERSION NUMBER HAS CHANGED, 
									// EVEN WHEN ONLY UPDATING KEY DEFINES
	var $wrnet_id = '0';

	var $fullname = 'Quest History';
	var $description = 'Addon to make the Quest History from the addon QuestGuru available in Roster.';
	var $credits = array(
		array(	"name"=>	"Joerg Hufen, 2008",
				"info"=>	"Displays the QuestHistory for a characters")
	);


	/**
	 * Install Function
	 *
	 * @return bool
	 */
	function install()
	{
		global $installer;

		// Master and menu entries
		$installer->add_config("'1','startpage','questhistory_conf','display','master'");
		$installer->add_config("'10','questhistory_conf',NULL,'blockframe','menu'");
		$installer->add_config("'20','questhistory_colors',NULL,'blockframe','menu'");
		$installer->add_config("'30', 'clear_history', 'rostercp-addon-questhistory-display', 'makelink', 'menu'");
		$installer->add_config("'1010','questhistory_access','0','access','questhistory_conf'");
		$installer->add_config("'1020','questassign_access','1','access','questhistory_conf'");
		$installer->add_config("'1030','questupdate_access','1','access','questhistory_conf'");
		$installer->add_config("'1040','questhistory_sorting','start','select{Start Time^start|Finished Time^finished|Level^level|Questname^title|Tag^tag','questhistory_conf'");
		$installer->add_config("'1050','questhistory_sorting_order','ASC','radio{ascending^ASC|descending^DESC','questhistory_conf'");
		$installer->add_config("'1060','display_zone_selector','1','radio{yes^1|no^0','questhistory_conf'");
		$installer->add_config("'1070','display_update_instructions','1','radio{yes^1|no^0','questhistory_conf'");
		$installer->add_config("'1080','scrollbox_height','300px','text{5|5','questhistory_conf'");
		$installer->add_config("'1090','scrollbox_color','sgreen','select{
		  					   Green^sgreen|
							   Blue^sblue|
							   Yellow^syellow|
							   Gray^sgray|
							   Red^sred|
							   Purple^spurple|
							   White^swhite|
							   Orange^sorange',
							   'questhistory_colors'");
		$installer->add_config("'1100','zonebox_color','sgreen','select{
		  					   Green^sgreen|
							   Blue^sblue|
							   Yellow^syellow|
							   Gray^sgray|
							   Red^sred|
							   Purple^spurple|
							   White^swhite|
							   Orange^sorange',
							   'questhistory_colors'");
		$installer->add_config("'1110','instructionbox_color','syellow','select{
		  					   Green^sgreen|
							   Blue^sblue|
							   Yellow^syellow|
							   Gray^sgray|
							   Red^sred|
							   Purple^spurple|
							   White^swhite|
							   Orange^sorange',
							   'questhistory_colors'");
		$installer->add_config("'1120','messagebox_color','sred','select{
		  					   Green^sgreen|
							   Blue^sblue|
							   Yellow^syellow|
							   Gray^sgray|
							   Red^sred|
							   Purple^spurple|
							   White^swhite|
							   Orange^sorange',
							   'questhistory_colors'");
		$installer->add_config("'1130','assistantbox_color','syellow','select{
		  					   Green^sgreen|
							   Blue^sblue|
							   Yellow^syellow|
							   Gray^sgray|
							   Red^sred|
							   Purple^spurple|
							   White^swhite|
							   Orange^sorange',
							   'questhistory_colors'");
		$installer->add_menu_button('Quest History','char');
		$installer->add_menu_button('Assign Quests','util');
 		$installer->create_table($installer->table('data'),"
								`auto-id` INT( 255 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
								`gid` INT( 11 ) NOT NULL ,
								`pid` INT( 11 ) NOT NULL ,
								`qid` INT( 10 ) NOT NULL ,
								`qlvl` TINYINT( 2 ) NOT NULL ,
								`slvl` TINYINT( 2 ) NOT NULL ,
								`flvl` TINYINT( 2 ) NOT NULL ,
								`tag` VARCHAR( 50 ) NOT NULL ,
								`zone` VARCHAR( 255 ) NOT NULL , 
								`title` VARCHAR( 255 ) NOT NULL,
								`description` TEXT NOT NULL,
								`rmoney` INT( 10 ) NOT NULL,
								`rewards` TEXT NOT NULL,
								`fgain` TEXT NOT NULL,
								`xp` INT( 10 ) NOT NULL,
								`honor` INT( 6 ) NOT NULL,
								`objectives` TEXT NOT NULL,
								`start` VARCHAR( 20 ) NOT NULL,
								`finished` VARCHAR( 20 ) NOT NULL,
								`daily` TINYINT( 1 ) NOT NULL,
								`group` TINYINT( 2 ) NOT NULL,
								`startposx` DECIMAL( 10,2 ) NOT NULL,
								`startposy` DECIMAL( 10,2 ) NOT NULL,
								`endposx` DECIMAL( 10,2 ) NOT NULL,
								`endposy` DECIMAL( 10,2 ) NOT NULL,
								`startnpczone` VARCHAR( 255 ) NOT NULL,
								`endnpczone` VARCHAR( 255 ) NOT NULL,
								`startnpcname` VARCHAR ( 255 ) NOT NULL,
								`endnpcname` VARCHAR( 255 ) NOT NULL,
								`requiredmoney` INT( 10 ) NOT NULL,
								`choices` TEXT NOT NULL, 
								INDEX ( `gid` , `pid`, `title` )");
 		$installer->create_table($installer->table('temp'),"
								`auto-id` INT( 255 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
								`qid` INT( 10 ) NOT NULL ,
								`qlvl` TINYINT( 2 ) NOT NULL ,
								`slvl` TINYINT( 2 ) NOT NULL ,
								`flvl` TINYINT( 2 ) NOT NULL ,
								`tag` VARCHAR( 50 ) NOT NULL ,
								`zone` VARCHAR( 255 ) NOT NULL , 
								`title` VARCHAR( 255 ) NOT NULL,
								`description` TEXT NOT NULL,
								`rmoney` INT( 10 ) NOT NULL,
								`rewards` TEXT NOT NULL,
								`fgain` TEXT NOT NULL,
								`xp` INT( 10 ) NOT NULL,
								`honor` INT( 6 ) NOT NULL,
								`objectives` TEXT NOT NULL,
								`start` VARCHAR( 20 ) NOT NULL,
								`finished` VARCHAR( 20 ) NOT NULL,
								`daily` TINYINT( 1 ) NOT NULL,
								`group` TINYINT( 2 ) NOT NULL,
								`startposx` DECIMAL( 10,2 ) NOT NULL,
								`startposy` DECIMAL( 10,2 ) NOT NULL,
								`endposx` DECIMAL( 10,2 ) NOT NULL,
								`endposy` DECIMAL( 10,2 ) NOT NULL,
								`startnpczone` VARCHAR( 255 ) NOT NULL,
								`endnpczone` VARCHAR( 255 ) NOT NULL,
								`startnpcname` VARCHAR ( 255 ) NOT NULL,
								`endnpcname` VARCHAR( 255 ) NOT NULL,
								`requiredmoney` INT( 10 ) NOT NULL,
								`choices` TEXT NOT NULL, 
								INDEX ( `title` )");
 		return true;
	}

	/**
	 * Upgrade Function
	 *
	 * @param string $oldversion
	 * @return bool
	 */
	function upgrade($oldversion)
	{
		global $installer;

		if( version_compare('1.9.9.1703', $oldversion,'>') == true )
		{
			$installer->drop_table($installer->table('data'));
			$installer->drop_table($installer->table('temp'));
	 		$installer->create_table($installer->table('data'),"
									`auto-id` INT( 255 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
									`gid` INT( 11 ) NOT NULL ,
									`pid` INT( 11 ) NOT NULL ,
									`qid` INT( 10 ) NOT NULL ,
									`qlvl` TINYINT( 2 ) NOT NULL ,
									`slvl` TINYINT( 2 ) NOT NULL ,
									`flvl` TINYINT( 2 ) NOT NULL ,
									`tag` VARCHAR( 50 ) NOT NULL ,
									`zone` VARCHAR( 255 ) NOT NULL , 
									`title` VARCHAR( 255 ) NOT NULL,
									`description` TEXT NOT NULL,
									`rmoney` INT( 10 ) NOT NULL,
									`rewards` TEXT NOT NULL,
									`fgain` TEXT NOT NULL,
									`xp` INT( 10 ) NOT NULL,
									`honor` INT( 6 ) NOT NULL,
									`objectives` TEXT NOT NULL,
									`start` VARCHAR( 20 ) NOT NULL,
									`finished` VARCHAR( 20 ) NOT NULL,
									`daily` TINYINT( 1 ) NOT NULL,
									`group` TINYINT( 2 ) NOT NULL,
									`startposx` DECIMAL( 10,2 ) NOT NULL,
									`startposy` DECIMAL( 10,2 ) NOT NULL,
									`endposx` DECIMAL( 10,2 ) NOT NULL,
									`endposy` DECIMAL( 10,2 ) NOT NULL,
									`startnpczone` VARCHAR( 255 ) NOT NULL,
									`endnpczone` VARCHAR( 255 ) NOT NULL,
									`startnpcname` VARCHAR ( 255 ) NOT NULL,
									`endnpcname` VARCHAR( 255 ) NOT NULL,
									`requiredmoney` INT( 10 ) NOT NULL,
									`choices` TEXT NOT NULL, 
									INDEX ( `gid` , `pid`, `title` )");
 			$installer->create_table($installer->table('temp'),"
									`auto-id` INT( 255 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
									`qid` INT( 10 ) NOT NULL ,
									`qlvl` TINYINT( 2 ) NOT NULL ,
									`slvl` TINYINT( 2 ) NOT NULL ,
									`flvl` TINYINT( 2 ) NOT NULL ,
									`tag` VARCHAR( 50 ) NOT NULL ,
									`zone` VARCHAR( 255 ) NOT NULL , 
									`title` VARCHAR( 255 ) NOT NULL,
									`description` TEXT NOT NULL,
									`rmoney` INT( 10 ) NOT NULL,
									`rewards` TEXT NOT NULL,
									`fgain` TEXT NOT NULL,
									`xp` INT( 10 ) NOT NULL,
									`honor` INT( 6 ) NOT NULL,
									`objectives` TEXT NOT NULL,
									`start` VARCHAR( 20 ) NOT NULL,
									`finished` VARCHAR( 20 ) NOT NULL,
									`daily` TINYINT( 1 ) NOT NULL,
									`group` TINYINT( 2 ) NOT NULL,
									`startposx` DECIMAL( 10,2 ) NOT NULL,
									`startposy` DECIMAL( 10,2 ) NOT NULL,
									`endposx` DECIMAL( 10,2 ) NOT NULL,
									`endposy` DECIMAL( 10,2 ) NOT NULL,
									`startnpczone` VARCHAR( 255 ) NOT NULL,
									`endnpczone` VARCHAR( 255 ) NOT NULL,
									`startnpcname` VARCHAR ( 255 ) NOT NULL,
									`endnpcname` VARCHAR( 255 ) NOT NULL,
									`requiredmoney` INT( 10 ) NOT NULL,
									`choices` TEXT NOT NULL, 
									INDEX ( `title` )");
		}
		return true;
	}

	/**
	 * Un-Install Function
	 *
	 * @return bool
	 */
	function uninstall()
	{
		global $installer;

		$installer->remove_all_config();

		$installer->drop_table($installer->table('questhistory'));
		$installer->remove_all_menu_button();
		return true;
	}
}
