<?php
/**
 * WoWRoster.net WoWRoster
 *
 * LICENSE: Licensed under the Creative Commons
 *          "Attribution-NonCommercial-ShareAlike 2.5" license
 *
 * @copyright  2002-2007 WoWRoster.net
 * @license    http://creativecommons.org/licenses/by-nc-sa/2.5   
 * 			   Creative Commons "Attribution-NonCommercial-ShareAlike 2.5"
 * @version    SVN: $Id: search.inc.php 1702 2008-03-12 20:40:00Z Nefuh $
 * @link       http://www.wowroster.net
 * @package    Quest History
 * @subpackage Search
*/

if( !defined('IN_ROSTER') )
{
    exit('Detected invalid access to this file!');
}

/**
 * News Search
 *
 * @package    News
 * @subpackage Search
 */
class questhistorySearch
{
	var $options;
	var $result = array();
	var $result_count = 0;
	var $start_search;
	var $stop_search;
	var $time_search;
	var $open_table;
	var $close_table;
	var $search_url;
	var $data = array();    // Addon data

	function search( $search , $limit=10 , $page=0 )
	{
		global $roster;

		$first = $page*$limit;
		$query = "SELECT * FROM `".$roster->db->table('members')."` 
				 WHERE `name` LIKE '%$search%'";
		if ($roster->db->query($query))
		{
			$result2 = $roster->db->query($query);
			if ($roster->db->num_rows($result2) > 0)
			{
				while ($data = $roster->db->fetch($result2)) {
				  	$pid = $data['member_id'];
				}
			}
		}
		$query = 'SELECT 
				 `qh`.`title`, 
				 `qh`.`header`, 
				 `qh`.`pid`, 
				 `qh`.`gid` 
				 FROM `'.$roster->db->table('data', 'questhistory')."` qh
				 WHERE `qh`.`title` LIKE '%$search%'
				 OR `qh`.`header` LIKE '%$search%' 
				 OR `qh`.`pid` = '$pid' ".( $limit > 0 ? " LIMIT $first," . $limit : '' ). ';';

		//calculating the search time
		$this->start_search = format_microtime();

		$result = $roster->db->query($query);

		$this->stop_search = format_microtime();
		$this->time_search = $this->stop_search - $this->start_search;

		$nrows = $roster->db->num_rows($result);

		$x = ($limit > $nrows) ? $nrows : ($limit > 0 ? $limit : $nrows);
		$search_row_class = 1;	
		if( $nrows > 0 )
		{
			$item['html'] = '<tr>
								<th class="membersHeader ts_string">'.
								$roster->locale->act['zone'].
								'</th><th class="membersHeader ts_string">'.
								$roster->locale->act['questtitle'].
								'</th><th class="membersHeader ts_string">'.
								$roster->locale->act['players'].
								'</th><th class="membersHeader ts_string">'.
								$roster->locale->act['guild'].
								'</th></tr>'."\n";
			$this->add_result($item);
			while( $x > 0 )
			{
				list($title, $header, $pid, $gid) = $roster->db->fetch($result);
				$query = "SELECT * FROM `".$roster->db->table('members')."` 
						 WHERE `member_id` = '$pid'";
				$result2 = $roster->db->query($query);
				while ($data = $roster->db->fetch($result2)) {
				  	$player = $data['name'];
				}
				$query = "SELECT * FROM `".$roster->db->table('guild')."` 
						 WHERE `guild_id` = '$gid'";
				$result2 = $roster->db->query($query);
				while ($data = $roster->db->fetch($result2)) {
				  	$guild = $data['guild_name'];
				}
				$item['html'] = '<tr class="SearchRowAltColor'.$search_row_class.'">
									<td class="SearchRowCell">'.
										$header.
									'</td><td style="text-align:left;" class="SearchRowCell">'.
										$title.
									'</td><td class="SearchRowCell"><a href="'.
										makelink('char-questhistory&amp;a=c:'.$pid).
									'" target="_self">'.
										$player.
									'</a>
									</td><td class="SearchRowCell"><a href="'.
										makelink('guild-memberslist&amp;a=g:'.$gid).
									'" target="_self">'.
										$guild.
									'</a></td></tr>'."\n";
				if ($search_row_class == 1)
				{
					$search_row_class++;				
				}
				else {
				  	$search_row_class = 1;
				}
				$this->add_result($item);
				unset($item);
				$x--;
			}
		}
		$roster->db->free_result($result);
	}

	function add_result( $resultarray )
	{
		$this->result[$this->result_count++] = $resultarray;
	}
}
