<?php
/**
 * WoWRoster.net WoWRoster
 *
 * LICENSE: Licensed under the Creative Commons
 *          "Attribution-NonCommercial-ShareAlike 2.5" license
 *
 * @copyright  2002-2007 WoWRoster.net
 * @license    http://creativecommons.org/licenses/by-nc-sa/2.5   
 * Creative Commons "Attribution-NonCommercial-ShareAlike 2.5"
 * @version    SVN: $Id: update_hook.php 1703 2008-11-09 19:11:14Z Nefuh $
 * @link       http://www.wowroster.net
 * @package    GuildHistory
 * @subpackage UpdateHook
*/

if ( !defined('IN_ROSTER') )
{
    exit('Detected invalid access to this file!');
}

/**
 * GuildHistory Update Hook
 *
 * @package    GuildHistory
 * @subpackage UpdateHook
 */
class questhistoryUpdate
{
	// Update messages
	var $messages = '';

	// Addon data object, recieved in constructor
	var $data;

	// LUA upload files accepted. We don't use any.
	var $files = array();
	var $timestamp = '';
	var $data_db = '';
	var $temp_db = '';
	/**
	 * Constructor
	 *
	 * @param array $data
	 *		Addon data object
	 */
	function questhistoryUpdate($data)
	{
	  	global $roster, $addon;
	  	$query = "SELECT `config_value` FROM `".$roster->db->table('addon_config')."` WHERE `config_type` = 'questhistory_conf' AND `id` = '1030'";
	  	$result = $roster->db->query($query);
	  	$arr = $roster->db->fetch_all($result);
	  	$access_level = $arr[0][0];
		if($roster->auth->getAuthorized($access_level) )
		{
			$this->files[] = 'questguru';
			$this->data = $data;
			$this->data_db = $roster->db->table('data', $data['basename']);
			$this->temp_db = $roster->db->table('temp', $data['basename']);
			$this->messages = '';
		}
	}

	/**
	 * Resets addon messages
	 */
	function reset_messages()
	{
		global $roster;
		/**
		 * We display the addon name at the beginning of the output line. If
		 * the hook doesn't exist on this side, nothing is output. If we don't
		 * produce any output (update method off) we empty this before returning.
		 */

		$this->messages = '<li>'.$roster->locale->act['questhistory'].'<ul>';
	}

	/**
	 * Update trigger
	 */
	function update()
	{
		global $roster, $update;
		if ($roster->db->query("TRUNCATE `".$this->temp_db."`")) 
		{
			$data = $update->uploadData['questguru'];
			$num_quests = count($data['QuestGuru_History']);
			$query_prefix =  "INSERT INTO `".$this->temp_db."` (
							 `qid`, 
							 `qlvl`,
							 `flvl`,
							 `slvl`,
							 `tag`,
							 `zone`,
							 `title`,
							 `description`, 
							 `rmoney`,
							 `rewards`,
							 `fgain`,
							 `xp`,
							 `honor`,
							 `objectives`,
							 `start`,
							 `finished`,
							 `daily`,
							 `group`,
							 `startposx`,
							 `startposy`, 
							 `endposx`, 
							 `endposy`,
							 `startnpczone`,
							 `endnpczone`,
							 `startnpcname`,
							 `endnpcname`,
							 `requiredmoney`,
							 `choices`
							 ) VALUES ";
			$query_part = '';
			for ($i=1; $i < $num_quests; $i++) 
			{
			  	$act_data = $data['QuestGuru_History'][$i];
		  		$act_data['StartTime'] = str_replace('/', '-', $act_data['StartTime']);
			  	$act_data['FinishTime'] = str_replace('/', '-', $act_data['FinishTime']);
			  	$act_data['StartTime'] = $this->correct_date($act_data['StartTime']);
			  	$act_data['FinishTime'] = $this->correct_date($act_data['FinishTime']);
			  	$tmp = explode('|', $act_data['Link']);
			  	$tmp2 = explode(':', $tmp[2]);
			  	$qid = $tmp2[1];
			  	unset($tmp, $tmp2);
			  	$qlvl = (int)$act_data['Level'];
				$flvl = (int)$act_data['FinishLevel'];
				$slvl = (int)$act_data['StartLevel'];
		  	  	if (empty($act_data['Daily'])) 
				{
				  	$daily = 0;
				}
				else
				{
				  	$daily = (int)$act_data['Daily'];
				}
				if (empty($act_data['Tag']))
				{
				  	$tag = '';
				}
				else
				{
				  	$tag = $roster->db->escape($act_data['Tag']);
				}
				if (!empty($act_data['Header']))
				{
					$zone = $roster->db->escape($act_data['Header']);
				}
				else
				{
				  	$zone = null;
				}
				if (!empty($act_data['Title']))
				{
					$title = $roster->db->escape($act_data['Title']);
				}
				else
				{
				  	$title = null;
				}
				if (!empty($act_data['Description']))
				{
					$description = $roster->db->escape($act_data['Description']);
					if (!empty($act_data['ObjectiveText']))
					{
					  	$description .= '<br />'.$roster->db->escape($act_data['ObjectiveText']);
					}
				}
				else
				{
					if (!empty($act_data['ObjectiveText']))
					{
					  	$description = $roster->db->escape($act_data['ObjectiveText']);
					}
					else
					{
					  	$description = null;
					}
				}
				if ( (!empty($act_data['RewardMoney'])) && ($act_data['RewardMoney'] > 0) )
				{
					$rmoney = $act_data['RewardMoney'];
				}
				else
				{
				  	$rmoney = 0;
				}
				$rewards = null;
				if ( (is_array($act_data['Reward'])) )
				{
					foreach ($act_data['Reward'] as $reward)
					{
					  $reward_num = (int)$reward['Count'];
					  $tmp = explode('|', $reward['Link']);
					  $reward_color = str_replace('cf', '', $tmp[1]);
					  $tmp2 = explode(':', $tmp[2]);
					  $reward_id = $tmp2[1];
					  $reward_name = str_replace(']', '', str_replace('h[', '', $tmp[3]));
					  $rewards .= $reward_num.'|'.$reward_color.'|'.$reward_id.'|'.$reward_name.'{';
					}
				}
				$rewards = $roster->db->escape($rewards);
				$fgain = null;
				if ( (isset($act_data['FactionGain'])) && (is_array($act_data['FactionGain'])) )
				{
				  	$factions = array_keys($act_data['FactionGain']);
  					foreach ($factions as $faction)
				  	{
					    $fgain .= $faction.'|'.(int)$act_data['FactionGain'][$faction].'{';
					}
					unset($factions);
				}
				$fgain = $roster->db->escape($fgain);
				if (!empty($act_data['XP']))
				{
					$xp = $act_data['XP'];
				}
				else
				{
				  	$xp = 0;
				}
				if (!empty($act_data['Honor']))
				{
					$honor = $act_data['Honor'];
				}
				else
				{
				  	$honor = 0;
				}
				$objectives = null;
				if ( is_array($act_data['Objective']))
				{
				  	foreach ($act_data['Objective'] as $objective)
				  	{
					    if ($objective['Type'] == 'item')
					    {
							$tmp = explode('|', $objective['Description']);
						  	$item_color = str_replace('cf', '', $tmp[1]);
						  	$tmp2 = explode(':', $tmp[2]);
						  	$item_id = $tmp2[1];
						  	$item_name = $roster->db->escape(str_replace(']', '', str_replace('h[', '', $tmp[3])));
						  	$desc = $item_color.'#'.$item_id.'#'.$roster->db->escape($item_name);
					  		$objectives .= $objective['Type'].'|'.$desc.'|'.$objective['numNeeded'].'{';
							unset($tmp, $tmp2);
						}
						else
						{
						  	$objectives .= $objective['Type'].'|'.$roster->db->escape($objective['Description']).'{';
						}
					}
				}
				$start = $act_data['StartTime'];
				$finished = $act_data['FinishTime'];
				$group = $act_data['SuggestedGroup'];
				if (!empty($act_data['StartPosX']))
				{
					$startposx = (float)$act_data['StartPosX'];
				}
				else
				{
				  	$startposx = 0;
				}
				if (!empty($act_data['StartPosY']))
				{
					$startposy = (float)$act_data['StartPosY'];
				}
				else
				{
				  	$startposy = 0;
				}
				if (!empty($act_data['FinishPosX']))
				{
					$endposx = (float)$act_data['FinishPosX'];
				}
				else
				{
				  	$endposx = 0;
				}
				if (!empty($act_data['FinishPosY']))
				{
					$endposy = (float)$act_data['FinishPosY'];
				}
				else
				{
				  	$endposy = 0;
				}
				if (!empty($act_data['StartNPCZone']))
				{
					$startnpczone = $roster->db->escape($act_data['StartNPCZone']);
				}
				else
				{
				  	$startnpczone = null;
				}
				if (!empty($act_data['FinishNPCZone']))
				{
					$endnpczone = $roster->db->escape($act_data['FinishNPCZone']);
				}
				else
				{
				  	$endnpczone = null;
				}
				if (!empty($act_data['StartNPCName']))
				{
					$startnpcname = $roster->db->escape($act_data['StartNPCName']);
				}
				else
				{
				  	$startnpcname = null;
				}
				if (!empty($act_data['FinishNPCName']))
				{
					$finishnpcname = $roster->db->escape($act_data['FinishNPCName']);
				}
				else
				{
				  	$finishnpcname = null;
				}
				if (!empty($act_data['RequiredMoney']))
				{
					$requiredmoney = $act_data['RequiredMoney'];
				}
				else
				{
				  	$requiredmoney = 0;
				}
				$choices = null;
				if ( is_array($act_data['Choice']))
				{
					foreach ($act_data['Choice'] as $choice)
					{
						$tmp = explode('|', $choice['Link']);
					  	$item_color = str_replace('cf', '', $tmp[1]);
					  	$tmp2 = explode(':', $tmp[2]);
					  	$item_id = $tmp2[1];
					  	$item_name = $roster->db->escape(str_replace(']', '', str_replace('h[', '', $tmp[3])));
					  	if (isset($choice['Selected']))
					  	{
						    $selected = $choice['Selected'];
						}
						else
						{
						  	$selected = 'false';
						}
				  		$choices .= $selected.'|'.$choice['Count'].'|'.$item_color.'|'.$item_id.'|'.$item_name.'{';
						unset($tmp, $tmp2);
					}	  
				}
			  	$choices = $roster->db->escape($choices);
				if (!empty($act_data['Title'])) 
			  	{
					$query_part .= "(
							 '".$qid."', 
							 '".$qlvl."',
							 '".$flvl."',
							 '".$slvl."',
							 '".$tag."',
							 '".$zone."',
							 '".$title."',
							 '".$description."',
							 '".$rmoney."',
							 '".$rewards."',
							 '".$fgain."',
							 '".$xp."',
							 '".$honor."',
							 '".$objectives."',
							 '".$start."',
							 '".$finished."',
							 '".$daily."',
							 '".$group."',
							 '".$startposx."',
							 '".$startposy."',
							 '".$endposx."',
							 '".$endposy."',
							 '".$startnpczone."',
							 '".$endnpczone."',
							 '".$startnpcname."',
							 '".$finishnpcname."',
							 '".$requiredmoney."',
							 '".$choices."'
							 ), ";
				}
				unset($act_data);
			}
			$query_part = trim($query_part, ', ');
		    if (!empty($query_part))
		    {
			  	if ($roster->db->query($query_prefix.$query_part))
			  	{
					$this->messages .= ' <li style="color:#00FF00;">'.
									   $roster->locale->act['quests_inserted'].
									   '</li>';
					$this->messages .= ' <li>'.
					 				   $roster->locale->act['go_to'].
									   '&nbsp;<a href="'.makelink('util-questhistory').'" target="_self">'.
									   $roster->locale->act['go_to_linktext'].
									   '</a>&nbsp;'.$roster->locale->act['to_assign_quests'].'</li>';		    
					$this->messages .= '</ul>';
					return true;
					$roster->db->query("TRUNCATE `".$this->temp_db."`");
				}
				else
				{
				  	$this->messages .= ' <li style="color:#FF0000;">'.
				  					   $roster->locale->act['quests_not_inserted'].
				  					   '</li>';
					return false;	
				}
			}
		}
		else 
		{
	  		$this->messages .= '<li>'.$roster->locale->act['temp_table_not_deleted'].'</li>';
			$this->messages .= '</ul>';
		  	return false;
		}
	}
	/**
	 * Name: correct_data
	 * Description: Function to convert datetime string from questguru format into mysql format
	 * Parameters: $old_string | Old formated string (DD-MM-YYYY HH:MM:SS)
	 * Returns: $new_string | New formated string (YYYY-MM-DD HH:MM:SS)
	 */
	function correct_date ($old_string)
	{
		// Split into $temp[0] = date and $temp[1] = time
		$temp = explode (' ', $old_string);
		// Split Date into Day, Month, Year 
		$temp2 = explode ('-', $temp[0]); 
		$day = $temp2[1];
		$month = $temp2[0];
		$year = $temp2[2];
		$time = $temp[1];
		unset($temp2);
		// Build new formated string an return
		$new_string = $year.'-'.$month.'-'.$day.' '.$time;
		return $new_string;			  
	}
}