<?php
/**
 * WoWRoster.net WoWRoster
 *
 * LICENSE: Licensed under the Creative Commons
 *          "Attribution-NonCommercial-ShareAlike 2.5" license
 *
 * @copyright  2002-2007 WoWRoster.net
 * @license    http://creativecommons.org/licenses/by-nc-sa/2.5   Creative Commons "Attribution-NonCommercial-ShareAlike 2.5"
 * @version    SVN: $Id: index.php 1703 2008-11-07 20:09:45Z Nefuh $
 * @link       http://www.wowroster.net
 * @package    QuestHistory
 */

if ( !defined('IN_ROSTER') )
{
    exit('Detected invalid access to this file!');
}
if( !$roster->auth->getAuthorized($addon['config']['questassign_access']) )
{
	print
	'<span class="title_text">'.$roster->locale->act['login'].'</span><br />'.
	$roster->auth->getLoginForm();
	return; //Kicks out of the AddOn and back to the Roster framework
}
else {
	require_once($addon['url'].'inc/functions.inc.php');
	if ( (isset($_REQUEST['task'])) && ($_REQUEST['task'] != '') )
	{
 		$task = $_REQUEST['task']; 	
	}
	else 
	{
  		$task = 'default';
	}

	$quests_updated = false;

	switch ($task)
	{
  		default:
			$query = "SELECT * FROM `".$roster->db->table('temp', 'questhistory')."`";
	  		if ($roster->db->query($query)) {
			    $result = $roster->db->query($query);
			    if ($roster->db->num_rows($result) > 0) {
		    	  	$query = "SELECT * FROM `".$roster->db->table('guild')."`";
		      		$result = $roster->db->query($query);
			  		$content = border(
					          $addon['config']['assistantbox_color'], 
					  		  'start', 
							  $roster->locale->act['questhistory'].
							  ' - '.
							  $roster->locale->act['assistant_step_1'], 
							  '50%')."\n";
			  		$content .= '<form action="'.makelink('util-questhistory').'" method="POST">'."\n";
			  		$content .= '<input type="hidden" name="task" value="step2" />'."\n";
					$content .= $roster->locale->act['select_guild'].': 
					            <select name="guild_id">'."\n";
					while ($data = $roster->db->fetch($result))
					{
					  	$content .= '	<option value="'.
						  				$data['guild_id'].
										'">'.
										$data['guild_name'].
										'&nbsp;&#064;&nbsp;'.
										$data['server'].
										'</option>'."\n";
					}		
					$content .= '</select>'.
								"\n".
								'&nbsp;
								<input type="submit" value="'.$roster->locale->act['btn_submit'].'" />'.
								"\n".
								'</form>'."\n";	  
					$content .= border($addon['config']['assistantbox_color'], 'end')."\n";
				}
				else {
		  			$content = border($addon['config']['messagebox_color'], 'start', $roster->locale->act['questhistory'], '50%');
			  		$content .= $roster->locale->act['no_data']."\n";
					$content .= border($addon['config']['messagebox_color'], 'end');
				}
			}
			else {
		  		$content = border($addon['config']['messagebox_color'], 'start', $roster->locale->act['questhistory'], '50%');
			  	$content .= $roster->locale->act['no_data']."\n";
				$content .= border($addon['config']['messagebox_color'], 'end');
			}
  			break;
  		
	  	case 'step2':
  			$guild_id = $_REQUEST['guild_id'];
	   		$query = "SELECT * FROM `".$roster->db->table('members')."` 
			   		 WHERE `guild_id` = '$guild_id' 
					 ORDER BY `name`";
	   		$result = $roster->db->query($query);
			$content = border(
					   $addon['config']['assistantbox_color'], 
					   'start', 
					   $roster->locale->act['questhistory'].
					   ' - '.
					   $roster->locale->act['assistant_step_2'], 
					   '50%')."\n";
			$content .= '<form action="'.makelink('util-questhistory').'" method="POST">'."\n";
			$content .= '<input type="hidden" name="task" value="step3" />'."\n";
			$content .= '<input type="hidden" name="guild_id" value="'.$guild_id.'" />'."\n";
			$content .= $roster->locale->act['select_character'].': 
						<select name="char_id">'."\n";
			while ($data = $roster->db->fetch($result))
			{
		  		$content .= '	<option value="'.
				  			$data['member_id'].'">'.
							$data['name'].'</option>'."\n";
			}		
			$content .= '</select>'."\n".'&nbsp;
						<input type="submit" value="'.$roster->locale->act['btn_submit'].'" />'."\n".
						'</form>'."\n";	  
			$content .= border($addon['config']['assistantbox_color'], 'end')."\n";
  			break;
  		
	  	case 'step3':
			$guild_id = $_REQUEST['guild_id'];
			$char_id = $_REQUEST['char_id'];
			$sql_prefix = null;
			$query = "SHOW COLUMNS FROM `".$roster->db->table('temp', 'questhistory')."`";
			$result = $roster->db->query($query);
			$data = $roster->db->fetch_all($result);
			foreach ($data as $value)
			{
				$fields[] = $value['Field'];
			}
			$sql_prefix = trim($sql_prefix, ', ');
			$sql_prefix .= ") VALUES ";
			$query = "SELECT * FROM `".$roster->db->table('temp', 'questhistory')."`";
			$res = $roster->db->query($query);
			$i =0;
			while ($data = $roster->db->fetch($res))
			{
			  	$sql = "SELECT * FROM `".$roster->db->table('data', 'questhistory')."` WHERE `gid` = '".$guild_id."' AND `pid` = '".$char_id."' AND `qid` = '".$data['qid']."'";
			  	$res2 = $roster->db->query($sql);
			  	if ($roster->db->num_rows($res2) == 0)
			  	{
					$sql_prefix = "INSERT INTO `".$roster->db->table('data', 'questhistory')."` (
								`gid`,
								`pid`,";
					foreach ($fields as $field)
					{
					  	if ($field != 'auto-id')
				  		{
					    	$sql_prefix .= '`'.$field.'`, ';
						}
					}
					$sql_prefix = trim($sql_prefix, ', ');
					$sql_prefix .= ') VALUES (';
				  	$sql_prefix .= '\''.$guild_id.'\', \''.$char_id.'\', ';
					foreach ($fields as $field)
					{
						if ($field != 'auto-id')
						{
						  	$sql_prefix .= '\''.$roster->db->escape($data[$field]).'\', ';
						}
					}	 
					$sql_prefix = trim($sql_prefix, ', ');
					$sql_prefix .= ')';
					$sqls[$i] = $sql_prefix;
					$i++;
				}
				else
				{
				  	$sql_prefix = "UPDATE `".$roster->db->table('data', 'questhistory')."` SET ";
				  	foreach ($fields as $field)
				  	{
				  	  	if ( ($field != 'auto-id') && ($field != 'qid') )
				  	  	{
						    $sql_prefix .= '`'.$field.'` = \''.$roster->db->escape($data[$field]).'\', ';
						}
					}
					$sql_prefix = trim($sql_prefix, ', ');
					$sql_prefix .= 'WHERE `gid` = \''.$guild_id.'\' AND `pid` = \''.$char_id.'\' AND `qid` = \''.$data['qid'].'\'';
					$sqls[$i] = $sql_prefix;
					$i++;
				}
			}
			$failed = false;
			foreach ($sqls as $query)
			{	
				if (!$roster->db->query($query))
				{
				  	$failed = true;
				  	$failed_query[] = $query;
				}
			}
			if ($failed == true)
			{
			  	$content = border('sred', 'start', $roster->locale->act['assistant_step_3'], '400px');
			  	$content .= $roster->locale->act['quests_not_assigned'].'<br>'."\n";
			  	$content .= 'Failed Queries:<br><ul style="list-style-type:none;">'."\n"; 
				foreach ($failed_query as $query)
			  	{
				    $content .= '<li>'.$query."</li>\n";
				}	
				$content .= '</ul>'."\n";
				$content .= border('sred', 'end');
			}
			else
			{
			 	$content = border('sgreen', 'start', $roster->locale->act['assistant_step_3'], '400px');
			  	$content .= $roster->locale->act['quests_assigned']."\n";
			  	$content .= border('sgreen', 'end');
			}
			break;
	}
}