<?php
/******************************
 * WoWRoster.net  Roster
 * Copyright 2002-2006
 * Licensed under the Creative Commons
 * "Attribution-NonCommercial-ShareAlike 2.5" license
 *
 * Short summary
 *  http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Full license information
 *  http://creativecommons.org/licenses/by-nc-sa/2.5/legalcode
 * -----------------------------
 *
 * $Id: membersRep.php 337 2006-12-09 10:40:34Z pleegwat $
 *
 ******************************/

if ( !defined('ROSTER_INSTALLED') )
{
    exit('Detected invalid access to this file!');
}

// --[ Build faction select box ]--
$qry_fct = "SELECT distinct(name) fct_name FROM ".ROSTER_REPUTATIONTABLE." ORDER BY name";

$result_fct = $wowdb->query($qry_fct) or die_quietly($wowdb->error(),'Database Error',basename(__FILE__),__LINE__,$qry_fct);

$choiceForm = '<form action="'.$script_filename.'" method="POST">
	'.$wordings[$roster_conf['roster_lang']]['faction_filter'].'
	<select name="factionfilter" onchange="top.location.href=this.options[this.selectedIndex].value">
		<option value="">Select Faction....</option>'."\n";

while($row_fct = $wowdb->fetch_array($result_fct))
{
	if( $_REQUEST['factionfilter'] == $row_fct['fct_name'] )
		$choiceForm .= '		<option value="'.$script_filename.'&amp;factionfilter='.$row_fct['fct_name'].'" selected="selected">'.$row_fct['fct_name']."</option>\n";
	else
		$choiceForm .= '		<option value="'.$script_filename.'&amp;factionfilter='.$row_fct['fct_name'].'">'.$row_fct['fct_name']."</option>\n";
}

$wowdb->free_result($result_fct);

$choiceForm .= '	</select>
</form><br />';

$content .= ($choiceForm);

// --[ If a faction is selected, build the box with rep levels ]--
if( isset($_REQUEST['factionfilter']) )
{
	$query = "SELECT m.name member, r.faction, r.name fct_name, curr_rep AS value, ".
		"curr_rep, ".
		"max_rep, ".
		"r.standing ".
		"FROM `".ROSTER_REPUTATIONTABLE."` r, ".ROSTER_MEMBERSTABLE." m ".
		"WHERE r.member_id = m.member_id";

	if( (isset($_REQUEST['factionfilter'])) && (($_REQUEST['factionfilter']) != 'All') )
		$query .= " AND r.name='".$wowdb->escape($_REQUEST['factionfilter'])."'";

	$query .=  " ORDER BY max_rep desc, r.standing DESC, curr_rep DESC";


	if (isset($_REQUEST['factionfilter']))
	{
		$result = $wowdb->query($query) or die_quietly($wowdb->error(),'Database Error',basename(__FILE__),__LINE__,$query);
	}

	$ab = array();
	$striping_counter = 1;
	$rep = array();

	while($row = $wowdb->fetch_array($result))
	{
		$category = $row['faction'];
		$faction = $row['fct_name'];
		$colorstyle = '';
		$imgbar = '';

		if ($row['standing'] == $wordings[$roster_conf['roster_lang']]['exalted'])
		{
		  $colorstyle = 'style=\'color : #007662;\'';
      $imgbar = 'addons/reputation/img/barbit_b.gif';	
		}
		else if ($row['standing'] == $wordings[$roster_conf['roster_lang']]['revered'])
		{
      $colorstyle = 'style=\'color : #227501;\'';
      $imgbar = 'addons/reputation/img/barbit_g.gif';
		}
    else if($row['standing'] == $wordings[$roster_conf['roster_lang']]['honored'])
    {
        $colorstyle = 'style=\'color : #547301;\'';
        $imgbar = 'addons/reputation/img/barbit_h.gif';
    }
		else if($row['standing'] == $wordings[$roster_conf['roster_lang']]['friendly'])
		{
		    $colorstyle = 'style=\'color : #787701;\'';
		    $imgbar = 'addons/reputation/img/barbit_f.gif';
		}
	  else if ($row['standing'] == $wordings[$roster_conf['roster_lang']]['neutral'])
	  {
	      $colorstyle = 'style=\'color : #A48618;\'';
				$imgbar = 'addons/reputation/img/barbit_y.gif';
	  }
	  else if ($row['standing'] == $wordings[$roster_conf['roster_lang']]['unfriendly'])
	  {
	      $colorstyle = 'style=\'color : orange;\'';
				$imgbar = 'addons/reputation/img/barbit_o.gif';
	  }
	  else if ($row['standing'] == $wordings[$roster_conf['roster_lang']]['hostile'])
	  {
	      $colorstyle = 'style=\'color : #974414;\'';
			  $imgbar = 'addons/reputation/img/barbit_host.gif';
	  }
	  else if ($row['standing'] == $wordings[$roster_conf['roster_lang']]['hated'])
	  {
	      $colorstyle = 'style=\'color : #FF3333;\'';
	      $imgbar = 'addons/reputation/img/barbit_r.gif';
	  }
	  $percent_exp = ($row['max_rep'] > 0 ? round(($row['curr_rep']/$row['max_rep'])*100) : 0);

		// Increment counter so rows are colored alternately
		++$striping_counter;

		$rep[$row['standing']] .=('<tr class="membersRow'. (($striping_counter % 2) +1) ."\">\n");
		$rep[$row['standing']] .=('<td class="membersRow'. (($striping_counter % 2) +1) .'"' . ' ' . $colorstyle . '>'.$row['member'].'</td>');
		$rep[$row['standing']] .=('<td class="membersRow'. (($striping_counter % 2) +1) .'"' . ' ' . $colorstyle . '>'.$row['standing'].'</td>');
		$rep[$row['standing']] .=('<td class="membersRowRight'. (($striping_counter % 2) +1) .'"' . ' ' . $colorstyle . '>'.'<div style="cursor:default;">'.'<div class="levelbarParent" style="width:100px;">'.'<div class="levelbarChild">' . $row['curr_rep'].' / '.$row['max_rep'].'</div>' .  '</div>' . '<table class="expOutline" border="0" cellpadding="0" cellspacing="0" width="100">' . '<tr>' . '<td style="background-image: url(\'' . $imgbar .'\');" width="'. $percent_exp .'%"><img src="img/pixel.gif" height="14" width="1" alt=""></td>' . '<td width="'.(100 - $percent_exp).'%"></td>' . '</tr>' . '</table>' . '</div></td>');
		$rep[$row['standing']] .=('</tr>');
	}

	$wowdb->free_result($result);

	$borderTop = border('syellow', 'start', $category.' - '.$faction);
	$tableHeader = '<table width="100%" cellspacing="0" class="bodyline">';
	$tableHeaderRow = '	<tr>
		<th class="membersHeader">'.$wordings[$roster_conf['roster_lang']]['rep_name'].'</th>
		<th class="membersHeader">'.$wordings[$roster_conf['roster_lang']]['rep_status'].'</th>
		<th class="membersHeaderRight">'.$wordings[$roster_conf['roster_lang']]['rep_value'].' / '.$wordings[$roster_conf['roster_lang']]['rep_max'].'</th>
		</tr>';
	$borderBottom = border('syellow', 'end');
	$tableFooter = '</table>';

	$content .=($borderTop);
	$content .=($tableHeader);
	$content .=($tableHeaderRow);

	$content .=($rep[$wordings[$roster_conf['roster_lang']]['exalted']]);
	$content .=($rep[$wordings[$roster_conf['roster_lang']]['revered']]);
	$content .=($rep[$wordings[$roster_conf['roster_lang']]['honored']]);
	$content .=($rep[$wordings[$roster_conf['roster_lang']]['friendly']]);
	$content .=($rep[$wordings[$roster_conf['roster_lang']]['neutral']]);
	$content .=($rep[$wordings[$roster_conf['roster_lang']]['unfriendly']]);
	$content .=($rep[$wordings[$roster_conf['roster_lang']]['hostile']]);
	$content .=($rep[$wordings[$roster_conf['roster_lang']]['hated']]);

	$content .=($tableFooter);
	$content .= $borderBottom;
}

?>
